#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:2
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=9
#SBATCH --job-name=det-pvoc
#SBATCH --time=60:00:00
#SBATCH --mem=90G
#SBATCH --constraint=p40
#SBATCH --exclude=gnodec1,gnodee8
#SBATCH --sockets-per-node=1

PYTHON='/scratch/shared/beegfs/yuki/envs/py37/bin/python3'

EXP_STR=$1
#EXP_STR="mocov2/places205"

EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
OUTPUT_DIR="${EXPERIMENT_PATH}/DET_PVOC"

cd detection

srun ${PYTHON} train_net.py \
       --resume --dist-url "auto" \
       --config-file configs/pascal_voc_R_50_C4_24k_moco.yaml \
       --num-gpus 2 MODEL.WEIGHTS ${EXPERIMENT_PATH}/converted.pkl \
        OUTPUT_DIR ${OUTPUT_DIR}

echo ${OUTPUT_DIR}